/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.util.Util;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.text.JTextComponent;

public class SubnetMaskJTextField
extends IPAddressJTextField {
    public SubnetMaskJTextField() {
        this.addFocusListener(new SubnetFocusListener());
    }

    public static boolean isSubnetLegal(String subnet) {
        if ("255.255.255.255".equals(subnet)) {
            return false;
        }
        String[] subnets = subnet.split("\\.");
        if (!"255".equals(subnets[0])) {
            return false;
        }
        String binarySubnet = "";
        for (String each : subnets) {
            if (each == null || each.equals("")) {
                return false;
            }
            binarySubnet = binarySubnet.concat(Util.addLeadingZeros(Integer.toBinaryString(Integer.valueOf(each)), 8));
        }
        int last = binarySubnet.lastIndexOf("1");
        return !binarySubnet.substring(0, last + 1).contains("0") && !binarySubnet.substring(last + 1).contains("1");
    }

    class SubnetFocusListener
    extends FocusAdapter {
        SubnetFocusListener() {
        }

        public void focusGained(FocusEvent evt) {
            String subnet = ((JTextComponent)evt.getSource()).getText();
            if (subnet == null || subnet.equals("") || subnet.equals("   .   .   .   ")) {
                ((JTextComponent)evt.getSource()).setText("255.255.255.  0");
            }
        }
    }
}

